//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//  
using System;
using System.Diagnostics;

namespace EventLogging
{
	/// <summary>
	/// Podsumowanie dla EventLoggingMain.
	/// </summary>
	class EventLoggingMain
	{
		const string log = "MyEventLog";
		const string source = "EventLoggingSource";
		
		static void Main(string[] args)
		{
			EventLog myApplicationLog = new EventLog("Application",".");
			foreach(EventLogEntry entry in myApplicationLog.Entries)
			{
				Console.WriteLine("\tEntry: " + entry.Message);
			}
			
//			if(!EventLog.SourceExists(source))
//			{
//				EventLog.CreateEventSource(source, log);
//			}
                
			// Utworzenie egzemplarza EventLog i przydzielenie jego rda.
			EventLog myLog = new EventLog(log, ".", source);

			// Zapisanie wpisu informacyjnego do dziennika zdarze.    
			myLog.WriteEntry("Zapis informacji do dziennika zdarze.");
			myLog.WriteEntry("Zapis bdu do dziennika zdarze.", EventLogEntryType.Error);
			myLog.WriteEntry("Zapis ostrzeenia do dziennika zdarze.", EventLogEntryType.Warning);
			myLog.WriteEntry("Zapis kontroli sukcesu do dziennika zdarze.", EventLogEntryType.SuccessAudit);
			myLog.WriteEntry("Zapis kontroli niepowodzenia do dziennika zdarze.", EventLogEntryType.FailureAudit);
			myLog.WriteEntry("Zapis do dziennika zdarze z identyfikatorem.", EventLogEntryType.Error, 1, 2);
			Console.ReadLine();
			myLog.Close();
			EventLog.DeleteEventSource("EventLoggingSource");
			EventLog.Delete("MyEventLog");
		}
	}
}
